<?php
// Database config
$host = "localhost";
$db   = "sweetfruit_brokers";
$user = "root";
$pass = "";

// Company email
$company_email = "info@sweetfruitbroker.com";

// Connect to DB
$conn = new mysqli($host, $user, $pass, $db);
if ($conn->connect_error) {
    die("Connection failed: " . $conn->connect_error);
}

// Simple function to clean inputs
function clean($data) {
    return htmlspecialchars(trim($data));
}

// Check required fields
$required = ['property_name', 'location', 'original_price', 'discounted_price', 'ownership_status', 'ownership_names', 'seller_name', 'mobile_number', 'comments'];
foreach ($required as $field) {
    if (empty($_POST[$field])) {
        die("Error: Missing $field");
    }
}

// Handle file uploads to 'uploads/' folder
function uploadFileSimple($fieldName, $allowedTypes = []) {
    if (!isset($_FILES[$fieldName]) || $_FILES[$fieldName]['error'] != 0) {
        return false;
    }
    $fileType = mime_content_type($_FILES[$fieldName]['tmp_name']);
    if ($allowedTypes && !in_array($fileType, $allowedTypes)) {
        return false;
    }
    $uploadDir = 'uploads/';
    if (!is_dir($uploadDir)) {
        mkdir($uploadDir, 0777, true);
    }
    $fileName = time() . '_' . basename($_FILES[$fieldName]['name']);
    $uploadFile = $uploadDir . $fileName;
    if (move_uploaded_file($_FILES[$fieldName]['tmp_name'], $uploadFile)) {
        return $fileName;
    }
    return false;
}

// Upload single PDF files
$legalDoc = uploadFileSimple('legal_doc', ['application/pdf']);
$proofDoc = uploadFileSimple('proof_doc', ['application/pdf']);

if (!$legalDoc || !$proofDoc) {
    die("Error: Please upload legal and proof documents in PDF.");
}

// Upload multiple images
function uploadMultipleFilesSimple($fieldName, $allowedTypes = []) {
    $uploadedFiles = [];
    if (!isset($_FILES[$fieldName])) return false;

    $totalFiles = count($_FILES[$fieldName]['name']);
    if ($totalFiles != 5) {
        die("Error: Exactly 5 images required.");
    }

    for ($i=0; $i < $totalFiles; $i++) {
        if ($_FILES[$fieldName]['error'][$i] !== 0) continue;
        $tmpName = $_FILES[$fieldName]['tmp_name'][$i];
        $type = mime_content_type($tmpName);
        if ($allowedTypes && !in_array($type, $allowedTypes)) {
            continue;
        }
        $uploadDir = 'uploads/';
        if (!is_dir($uploadDir)) {
            mkdir($uploadDir, 0777, true);
        }
        $fileName = time() . '_' . basename($_FILES[$fieldName]['name'][$i]);
        $uploadFile = $uploadDir . $fileName;
        if (move_uploaded_file($tmpName, $uploadFile)) {
            $uploadedFiles[] = $fileName;
        }
    }
    return count($uploadedFiles) === 5 ? implode(',', $uploadedFiles) : false;
}

$images = uploadMultipleFilesSimple('images', ['image/jpeg','image/png','image/gif','image/webp']);
if (!$images) {
    die("Error: Upload 5 valid images.");
}

// Prepare and insert into DB
$property_name = clean($_POST['property_name']);
$location = clean($_POST['location']);
$original_price = (int)$_POST['original_price'];
$discounted_price = (int)$_POST['discounted_price'];
$ownership_status = clean($_POST['ownership_status']);
$ownership_names = clean($_POST['ownership_names']);
$seller_name = clean($_POST['seller_name']);
$mobile_number = clean($_POST['mobile_number']);
$comments = clean($_POST['comments']);

$stmt = $conn->prepare("INSERT INTO properties (property_name, location, original_price, discounted_price, ownership_status, ownership_names, seller_name, mobile_number, legal_doc, proof_doc, images, comments) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
$stmt->bind_param("ssddssssssss", $property_name, $location, $original_price, $discounted_price, $ownership_status, $ownership_names, $seller_name, $mobile_number, $legalDoc, $proofDoc, $images, $comments);

if ($stmt->execute()) {
    // Send simple email notification
    $to = $company_email;
    $subject = "New Property Submission from Sweetfruit Brokers";
    $message = "New property submitted:\n
    Property Name: $property_name
    Location: $location
    Original Price: TZS $original_price
    Discounted Price: TZS $discounted_price
    Ownership Status: $ownership_status
    Ownership Names: $ownership_names
    Seller Name: $seller_name
    Mobile Number: $mobile_number
    Comments: $comments

    Uploaded Documents:
    Legal Doc: $legalDoc
    Proof Doc: $proofDoc
    Images: $images
    ";

    $headers = "From: no-reply@sweetfruitbroker.com";

    mail($to, $subject, $message, $headers);

    echo "Submission successful! Thank you.";
} else {
    echo "Error: " . $stmt->error;
}

$stmt->close();
$conn->close();
?>
